/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

static const char __idstring[] = "@(#)$Id: mx_init.c,v 1.19 2005/06/29 00:23:16 eugene Exp $";

#include <pthread.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>

#include "mx_auto_config.h"
#include "myriexpress.h"
#include "internal.h"

//pthread_mutex_t Mx_lock = PTHREAD_MUTEX_INITIALIZER;
pthread_mutex_t Mx_tx_lock = PTHREAD_MUTEX_INITIALIZER;
pthread_mutex_t Mx_rx_lock = PTHREAD_MUTEX_INITIALIZER;
pthread_mutex_t Mx_po_lock = PTHREAD_MUTEX_INITIALIZER;
int Mx_init_count = 0;
struct mx_endpoint Mx_endpoints;
pthread_t Mx_rx_thread;
pthread_t Mx_tx_thread;
int Mx_main_cancel = 0;
pthread_cond_t Mx_send_cond = PTHREAD_COND_INITIALIZER;
int ENDPOINT_BASE = 7000;


void* mx__tx_thread(void* p)
{
  usleep(2000);
  while (Mx_main_cancel == 0) {
    pthread_mutex_lock(&Mx_tx_lock);
    mx_run_asynch_tx(NULL);
    pthread_mutex_unlock(&Mx_tx_lock);
  }
  return NULL;
}

void* mx__rx_thread(void* p)
{
  while (Mx_main_cancel == 0) {
    MX_LIST_APPLY(struct mx_endpoint, &Mx_endpoints, mx_run_asynch_rx);
  }
  return NULL;
}

mx_return_t
mx__init_api (int api)
{
  char *s;
  pthread_mutex_lock(&Mx_po_lock);
  s = getenv("ENDPOINT_BASE");
  if (s != NULL){
    ENDPOINT_BASE = atoi(s);
  }
  if (Mx_init_count == 0) {
    MX_DEBUG_PRINT(MX_DEBUG_TCP_LIB,("first time\n"));
    ++Mx_init_count;
    Mx_endpoints.prev = Mx_endpoints.next = &Mx_endpoints;
    pthread_create(&Mx_tx_thread, NULL, mx__tx_thread, NULL);
    pthread_create(&Mx_rx_thread, NULL, mx__rx_thread, NULL);
  }
  pthread_mutex_unlock(&Mx_po_lock);
  return MX_SUCCESS;
}
